<?php
//print_r($_GET);
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}

global $product;

$attribute_keys = array_keys($attributes);

$parent_cat = wp_get_post_terms($product->get_id(), 'product_cat', array( 'parent' => 0,'fields' => 'ids' ));
$sub_cat = wp_get_post_terms($product->get_id(), 'product_cat', array( 'parent' =>$parent_cat[0],'fields' => 'names' ));
$current_variationID = $_GET['variation_id'];
$ext_ref = externe_referrer();
$class_back = "";
$category_link = get_category_link($parent_cat[0]);
if($ext_ref) {
    $class_back = "ext-link";
}
if (!function_exists('print_attribute_radio')) {

    function print_attribute_radio($checked_value, $value, $label, $name, $index=0) {
       
        $current_color = $_GET['attribute_couleur'];
        $selected = $default_checked = "";
        if ($value == strtolower($current_color)){
            $default_checked = "checked";
            $selected = "selected";
        }
           
        $checked = sanitize_title($checked_value) === $checked_value ? checked($checked_value, sanitize_title($value), false) : checked($checked_value, $value, false);

        $input_name = 'attribute_' . esc_attr($name);

        $esc_value = esc_attr($value);
        $id = esc_attr($name . '_v_' . $value);
        if ($name == 'pa_couleur') {
            $hexa = nap_color_attribute($value);
            $filtered_label = apply_filters('woocommerce_variation_option_name', $label);
            printf(' <style>
                        #' . $id . ':after { background-color: ' . $hexa . '; }
                    </style><li class="color-list '.$selected.' " data-color="' . $hexa . '">
                    <input data-color="' . $hexa . '" type="radio" name="%1$s" value="%2$s" id="%3$s" %4$s ' . $default_checked . '></li>', $input_name, $esc_value, $id, $checked, $filtered_label);
        } else {
            $icons = nap_icon_format($value);
            
                $format_img='<img src="'.$icons['inactive'].'" data-img = "'.$icons['inactive'].'" data-img-active = "'.$icons['active'].'" id="format_'.$index.'">';
            
            
            $filtered_label = apply_filters('woocommerce_variation_option_name', $label);
            printf('<li class="format-list selected"><input type="radio" name="%1$s" value="%2$s" id="%3$s" %4$s>

                <label class="format-label" for="%3$s">'.$format_img.'</label>
                <div class="format-desc">'.$label.'</span>
                </li>', $input_name, $esc_value, $id, $checked, $filtered_label); //<label class="format-label" style="background:url(' . $icons['inactive'] . ')" for="%3$s"></label>
        }
    }

}   

do_action('woocommerce_before_add_to_cart_form');
?>

<div id="product" class="clearfix">
    <div class="product-images row animated">
        <div class = "btn-wrapper row close-panel <?php echo $class_back ?>">
            <div class="pink-btn circle-btn"><a href="<?php echo $category_link ?>"><span class = "abs-center backlink">Retour</span></a></div>
        </div>
        <div class="product-slides row">
            <div class="product-header">
                <h2 class="crete -italic font-small"><?php echo $sub_cat[0]; ?></h2>
                <h3 class="crete"><?php the_title();?></h3>
            </div>
            <div class="slides-wrapper center">
                <div class="row">
                    <div class="nav-slider transition">
                        <ul>
                            <li id = "mozaique"><span class="icon mozaique row"></span><span class="desc">Mozaïque</span></li>
                            <li id = "zoom" data-active="false" ><span class="icon zoom"></span><span class="desc">Zoom</span></li>
                            <li><span class="icon download"></span><span class="desc">Télécharger</span></li>
                        </ul>
                    </div>
                    <div id="slides"> 
                        <?php
                        $variations = $product->get_available_variations();
                        $var_colors = nap_distinct_color_variations($variations);
                        foreach ($var_colors as $key => $value) :
                            ?>
                            <div style="background-image:url('<?php echo get_the_post_thumbnail_url($key, 'medium') ?>')" class="image element-slider  easyzoom easyzoom--overlay easyzoom--with-toggle" data-color = "<?php echo $value ?>" data-slick-index = "1">
                                <a href="<?php echo get_the_post_thumbnail_url($key, 'full') ?>">
                                    <!--<img src="<?php echo get_the_post_thumbnail_url($key, 'medium') ?>" alt="" />-->
                                </a>
                            </div>

                            <?php
                        endforeach;
                        ?>

                        <?php
                        if (get_field('images_ambiance', 'product_cat_' . $subcat_iD)):
                            $ambiance = array();
                            while (has_sub_field('images_ambiance', 'product_cat_' . $subcat_iD)) :
                                $image_amb = get_sub_field('img_ab');
                                $ambiance [] = $image_amb;
                                $attachment = wp_get_attachment_image_src($image_amb, 'medium');
                                $hd = wp_get_attachment_image_src($image_amb, 'full');
                                ?>
                                <div  style="background-image:url('<?php echo $attachment[0]; ?>')" class="image element-slider  easyzoom easyzoom--overlay easyzoom--with-toggle" data-color = "<?php echo $color ?>" data-slick-index = "1">
                                    <a href="<?php echo $hd[0]; ?>">
                                        <!--<img src="<?php echo $attachment[0]; ?>" alt="" />-->
                                    </a>
                                </div>

                                <?php
                            endwhile;
                        endif;
                        ?>

                    </div>  
                </div>
                <div class="gallery clearfix">
                    <div class="gallery-content clearfix">
                        <span class="close-btn"></span>

                        <?php foreach ($var_colors as $key => $value) : ?>
                            <article class = "row" data-color = "<?php echo $value; ?>">
                                <a href="<?php echo get_the_post_thumbnail_url($key, 'full') ?>"></a>
                                <figure>
                                    <img src="<?php echo get_the_post_thumbnail_url($key, 'medium') ?>" alt="" title="">
                                </figure>
                            </article>
                            <?php
                        endforeach;
                        if(!empty($ambiance)):
                            foreach ($ambiance as $key => $value) :
                                $attachment = wp_get_attachment_image_src($value, 'medium');
                                $hd = wp_get_attachment_image_src($value, 'full');
                                ?>

                                <article class = "row" data-color = "red">
                                    <a class = "download-btn" href="<?php echo $hd[0]; ?>" download></a>
                                    <figure>
                                        <img src="<?php echo $attachment[0]; ?>" alt="" title="">
                                    </figure>
                                </article>
                            <?php 
                            endforeach;
                        endif;
                        ?>


                    </div>
                </div>
            </div> 
        </div>
    </div>


    <div class="product-details full-height row right clearfix transition">

        <form class="variations_form cart left row" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint($product->get_id()); ?>" data-product_variations="<?php echo htmlspecialchars(wp_json_encode($available_variations)) ?>">
            <?php do_action('woocommerce_before_variations_form'); ?>

            <?php if (empty($available_variations) && false !== $available_variations) : ?>
                <p class="stock out-of-stock"><?php _e('This product is currently out of stock and unavailable.', 'woocommerce'); ?></p>
            <?php else : ?>
                <div class="variations" cellspacing="0">
                        
                    <?php 
                    $i=0;
                    foreach ($attributes as $name => $options) : ?>
                        <div class="list row <?php echo $name;?> left border-l center">

                            <div class="product-header center font-small label">
                                <label for="<?php echo sanitize_title($name); ?>" class = "chevron bottom"> <?php if($i==0) /*echo 'choix de la '*/; else /*echo 'choix du '*/; ?><?php echo strtolower(wc_attribute_label($name)); ?></label>
                            </div>
                            <?php
                            $sanitized_name = sanitize_title($name);
                            if (isset($_REQUEST['attribute_' . $sanitized_name])) {
                                $checked_value = $_REQUEST['attribute_' . $sanitized_name];
                            } elseif (isset($selected_attributes[$sanitized_name])) {
                                $checked_value = $selected_attributes[$sanitized_name];
                            } else {
                                $checked_value = '';
                            }
                            ?>
                            <ul class="value">
                                <?php
                                if (!empty($options)) {
                                    if (taxonomy_exists($name)) {
                                        // Get terms if this is a taxonomy - ordered. We need the names too.
                                        $terms = wc_get_product_terms($product->get_id(), $name, array('fields' => 'all'));

                                        foreach ($terms as $key=>$term) {
                                            if (!in_array($term->slug, $options)) {
                                                continue;
                                            }
                                            print_attribute_radio($checked_value, $term->slug, $term->name, $sanitized_name,$key);
                                            
                                        }
                                    } else {
                                        foreach ($options as $option) {
                                            print_attribute_radio($checked_value, $option, $option, $sanitized_name);
                                           
                                        }
                                    }
                                }

                                echo end($attribute_keys) === $name ? apply_filters('woocommerce_reset_variations_link', '<a class="reset_variations" href="#">' . __('Clear', 'woocommerce') . '</a>') : '';
                                ?>
                            </ul>
                        </div>
                    <?php $i++;endforeach; ?>

                </div>

                <?php do_action('woocommerce_before_add_to_cart_button'); ?>

                <div class="single_variation_wrap">
                    <?php
                    do_action('woocommerce_before_single_variation');
                    do_action('woocommerce_single_variation');
                    do_action('woocommerce_after_single_variation');
                    ?>
                </div>

                <?php do_action('woocommerce_after_add_to_cart_button'); ?>
            <?php endif; ?>

            <?php do_action('woocommerce_after_variations_form'); ?>

        </form>
        <div class="product-info row center left border-l">
                <div class="info-content">

                    <h2 class = "crete  font-small" ><?php echo $sub_cat[0]; ?></h2>
                    <h3 class = "crete  font-small info-attr" ><span class="info-format"><?php echo $_GET['attribute_format']?></span> <span class="info-color"><?php echo$_GET['attribute_couleur'] ?></span></h3>
                    <div class="details font-small">
                        <p class="info-format-txt"><?php echo $_GET['attribute_format']?></p>
                        <p class="pq"><?php echo nap_variable_meta($current_variationID, 'variation_description'); ?></p>
                    </div>
                    <div class="price">
                        <span class="crete"><?php echo nap_variable_meta($current_variationID, 'price'); ?> € ht</span>
                        <div class="notice">( prix public conseillé )</div>
                        <div class="font-small">
                            <div class="product_meta">

                                <?php do_action('woocommerce_product_meta_start'); ?>

                                <?php if (wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type('variable') )) : ?>

                                    <span class="sku_wrapper"><span class="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : nap_variable_meta($current_variationID, 'sku'); ?></span></span>

                                <?php endif; ?>


                                <?php do_action('woocommerce_product_meta_end'); ?>

                            </div>

                        </div>
                    </div>
                </div>
                <div class = "btn-list">
                    <a href="<?php echo get_permalink(157); ?>" class="btn pink-btn rounded">Nous contacter</a>
                    <a class="btn pink-btn rounded download-btn download_file">Télécharger la fiche technique </a>
                    <a href="<?php echo get_permalink(43); ?>?product_id=<?php echo $product->get_id()?>&" class="hidden download_file_link" id="<?php echo $current_variationID ?>"></a>
                </div>
                <div class="font-small circle-btn add-icon show-product"><span class= "abs-center">Produits associées</span></div>
            </div>
    </div>
    <div class="product-list transition border-l fixed">
        <div class="suggest-header">
            <h2>Produits associés</h2>
            <span class="close-btn"></span>
        </div>
        <div class="product-list-content"> 
            <article class = "row full-width">
                <a href="#"></a>
                <figure>
                    <img src="http://nap.mano.fr/wp-content/uploads/2017/07/505714-papier-toilette-jumbo-500x375.jpg" alt="" title="">
                </figure>
                <h3 class = "font-small" >Bobines papier toilette</h3>
            </article>
            <article class = "row full-width">
                <a href="#"></a>
                <figure>
                    <img src="http://nap.mano.fr/wp-content/uploads/2017/07/450108-flexibles-noirs-21cm-315x500.jpg" alt="" title="">
                </figure>
                <h3 class = "font-small" >Pailles</h3>
            </article>
            
            
        </div>
    </div>
</div>
