<?php
//print_r($_GET);
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}

global $product;
$id = get_the_ID();
$parent_cat = wp_get_post_terms($product->get_id(), 'product_cat', array( 'parent' => 0,'fields' => 'ids' ));
$sub_cat = wp_get_post_terms($product->get_id(), 'product_cat', array( 'parent' =>$parent_cat[0],'fields' => 'names' ));
//Get Back URL
$ext_ref = externe_referrer();
$class_back = "";
if($ext_ref) {
  $category_link = get_category_link($parent_cat[0]);
  $class_back = "ext-link";
}else{
  $category_link ="#";
}
do_action('woocommerce_before_add_to_cart_form');
?>

<div id="product" class="clearfix">
    <div class="product-images row animated">
        <div class = "btn-wrapper row close-panel <?php echo $class_back ?>">
            <div class="pink-btn circle-btn "><a href="<?php echo $category_link ?>"><span class = "abs-center backlink">Retour</span></a></div>
        </div>
        <div class="product-slides row">
            <div class="product-header">
                <h2 class="crete -italic font-small"><?php echo $sub_cat[0] ?></h2>
                <h3 class="crete"><?php the_title(); ?></h3>
            </div>
            <div class="slides-wrapper center">
                <div class="row">
                    <div class="nav-slider transition">
                        <ul>
                            <li id = "mozaique"><span class="icon mozaique row"></span><span class="desc">Mozaïque</span></li>
                            <li id = "zoom" data-active="false" ><span class="icon zoom"></span><span class="desc">Zoom</span></li>
                            <li><span class="icon download"></span><span class="desc">Télécharger</span></li>
                        </ul>
                    </div>
                    <div id="slides"> 
                        <?php
                        ?>
                        <div style="background-image:url('<?php echo get_the_post_thumbnail_url($ID, 'medium') ?>')" class="image element-slider  easyzoom easyzoom--overlay easyzoom--with-toggle"  data-slick-index = "1">
                            <a href="<?php echo get_the_post_thumbnail_url($ID, 'full') ?>">
                                <!--<img src="<?php echo get_the_post_thumbnail_url($ID, 'medium') ?>" alt="" />-->
                            </a>
                        </div>


                        <?php
                        /* if (get_field('images_ambiance', 'product_cat_' . $subcat_iD)):
                          $ambiance = array();
                          while (has_sub_field('images_ambiance', 'product_cat_' . $subcat_iD)) :
                          $image_amb = get_sub_field('img_ab');
                          $ambiance [] = $image_amb;
                          $attachment = wp_get_attachment_image_src($image_amb, 'medium');
                          $hd = wp_get_attachment_image_src($image_amb, 'full');
                          ?>
                          <div  style="background-image:url('<?php echo $attachment[0]; ?>')" class="image element-slider  easyzoom easyzoom--overlay easyzoom--with-toggle"  data-slick-index = "1">
                          <a href="<?php echo $hd[0]; ?>">
                          <!--<img src="<?php echo $attachment[0]; ?>" alt="" />-->
                          </a>
                          </div>

                          <?php
                          endwhile;
                          endif; */
                        ?>

                    </div>  
                </div>
                <div class="gallery clearfix">
                    <div class="gallery-content clearfix">
                        <span class="close-btn"></span>


                        <article class = "row" data-color = "">
                            <a href="<?php echo get_the_post_thumbnail_url($ID, 'full') ?>"></a>
                            <figure>
                                <img src="<?php echo get_the_post_thumbnail_url($ID, 'medium') ?>" alt="" title="">
                            </figure>
                        </article>
                        <?php
                        if (!empty($ambiance)):
                            foreach ($ambiance as $key => $value) :
                                $attachment = wp_get_attachment_image_src($value, 'medium');
                                $hd = wp_get_attachment_image_src($value, 'full');
                                ?>

                                <article class = "row" data-color = "red">
                                    <a class = "download-btn" href="<?php echo $hd[0]; ?>" download></a>
                                    <figure>
                                        <img src="<?php echo $attachment[0]; ?>" alt="" title="">
                                    </figure>
                                </article>
                                <?php
                            endforeach;
                        endif;
                        ?>


                    </div>
                </div>
            </div> 
        </div>
    </div>

    <?php $formats = explode(',', nap_variation_format($id)); ?>
    <div class="product-details full-height row right transition">
       
        <div class="product-info row center right border-l">
            <div class="info-content">
                <?php $formats = explode(',', nap_variation_format($id)); ?>
                <h2 class = "crete  font-small" ><?php echo $sub_cat[0] ?></h2>
                <h3 class = "crete  font-small info-attr" ><span class="info-format"><?php echo $formats[0]; ?></span> <span class="info-color"><?php echo$_GET['attribute_couleur'] ?></span></h3>
                <div class="details font-small">
                    <p class="info-format-txt"> 
                        <?php echo $formats[0]; ?>
                    </p>
                    <p class="pq"><?php echo do_shortcode(get_the_excerpt());?></p>
                </div>
                <div class="price">
                    <span class="crete"><?php echo $price = get_post_meta(get_the_ID(), '_regular_price', true); ?> € ht</span>
                    <div class="notice">( prix public conseillé )</div>
                    <div class="font-small">
                        <div class="product_meta">

                            <?php do_action('woocommerce_product_meta_start'); ?>

                            <?php if (wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type('variable') )) : ?>

                                <span class="sku_wrapper"><span class="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : nap_variable_meta($current_variationID, 'sku'); ?></span></span>

                            <?php endif; ?>


                            <?php do_action('woocommerce_product_meta_end'); ?>

                        </div>

                    </div>
                </div>
            </div>
            <div class = "btn-list">
                <a href="<?php echo get_permalink(157); ?>" class="btn pink-btn rounded">Nous contacter</a>
                <a class="btn pink-btn rounded download-btn download_file">Télécharger la fiche technique </a>
                <a href="<?php echo get_permalink(43); ?>?product_id=<?php echo $product->get_id() ?>&" class="hidden download_file_link" id="<?php echo $current_variationID ?>"></a>
            </div>
            <div class="font-small circle-btn add-icon show-product"><span class= "abs-center">Produits associées</span></div>
        </div>
    </div>
    <div class="product-list transition border-l fixed">
        <div class="suggest-header">
            <h2>Produits associés</h2>
            <span class="close-btn"></span>
        </div>
        <div class="product-list-content"> 
            <article class = "row full-width">
                <a href="#"></a>
                <figure>
                    <img src="http://nap.mano.fr/wp-content/uploads/2017/07/505714-papier-toilette-jumbo-500x375.jpg" alt="" title="">
                </figure>
                <h3 class = "font-small" >Bobines papier toilette</h3>
            </article>
            <article class = "row full-width">
                <a href="#"></a>
                <figure>
                    <img src="http://nap.mano.fr/wp-content/uploads/2017/07/450108-flexibles-noirs-21cm-315x500.jpg" alt="" title="">
                </figure>
                <h3 class = "font-small" >Pailles</h3>
            </article>


        </div>
    </div>
</div>
