<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     2.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
$current_page = 'catalogue';
get_header();
$product;
$cate = get_queried_object();
$cateID = $cate->term_id;

//SubCats
$child_category = get_terms('product_cat', array('parent' => $cateID, 'child_of' => the_category_ID(), 'exclude' => $cateID, 'orderby' => 'title', 'order' => 'ASC'));
?>

<div class="container clearfix" id="catalogue" data-page = "<?php echo $cateID; ?>">
    <div class="container-bg abs-full"></div>
    <?php get_sidebar() ?>
    <div class="right-container">
        <div class="left-panel fixed-full position--after-menu ">
            <div class="filter-wrapper">
                <div class="filter-btn fixed position--after-menu">
                    <div class="btn-container"><span class="abs-center font-small">Filtres</span></div>
                </div>
                <div class="filter-content">
                    <div class="filter-list fixed position--after-menu">
                        <div class="top-header">
                            <span>Filtres</span>
                            <span class="close-btn"></span>
                        </div>

                        <?php
                        $attributes = array('Univers' => 'pa_univers', 'Matiére' => 'pa_matiere', 'Format' => 'pa_format', 'Couleurs' => 'pa_couleur');
                        foreach ($attributes as $key => $value) :
                            ?>
                            <div class="filter-bloc">
                                <div class="header">
                                    <p><span><?php echo $key ?></span></p>
                                </div>

                                <?php
                                $terms = get_terms($value);

                                if (!empty($terms) && !is_wp_error($terms)):
                                    ?>
                                    <div class="bloc-content">
                                        <ul <?php if ($value == 'pa_couleur') echo 'class = "list-color-filter clearfix"'; ?>>
                                            <?php
                                            foreach ($terms as $term) :
                                                if ($value == 'pa_couleur'):
                                                    $color = get_field('couleurs', 'pa_couleur_' . $term->term_id);

                                                    if (isset($color) && strlen($color) > 0):
                                                        ?>
                                                        <li data-color = "<?php echo $color; ?>" class="<?php echo $term->name; ?>"></li>
                                                        <?php
                                                    endif;
                                                else :
                                                    ?>
                                                    <li><?php echo $term->name; ?></li>
                                                <?php
                                                endif;
                                            endforeach;
                                            if ($value == 'pa_couleur'):
                                                ?>

                                                <li class="reinit">Tout déselectionner</li>
                                            <?php endif; ?>
                                        </ul>

                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>



                        <div class="center filter-btn-list">
                            <div class="btn pink-btn rounded" id="search-btn">Rechercher</div>
                            <span class = "reinit-all">Effacer les filtres</span>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            foreach ($child_category as $key => $value) :
                ?>
                <div class="cover-wrapper abs-full transition" data-cat = "#cat<?php echo $value->term_id ?>" style = "background-image: url('<?php echo nap_category_image($value->term_id) ?>')">
                    <div class="cover-desc-wrapper">
                        <p><?php echo $value->description; ?></p>
                    </div>
                </div>   
                <?php
            endforeach;
            ?>
        </div>
        <div class="right-panel right">
            <div class="panel panel-content list-animation">
                <?php foreach ($child_category as $key => $value) : ?>
                    <section id = "cat<?php echo $value->term_id ?>">
                        <h2 class="crete small-title"><?php echo $value->name ?></h2>
                        <div class="product-list">
                            <?php
                            $args = array('post_type' => 'product', 'stock' => 1, 'posts_per_page' => -1, 'product_cat' => $value->name, 'orderby' => 'title' , 'order' => 'ASC');
                            $naps_posts = new WP_Query($args);
                            $options = array();

                            while ($naps_posts->have_posts()) : $naps_posts->the_post();
                                $id = get_the_ID();

                                $options['size'] = (get_field('produit_affichage', $id)) ? get_field('produit_affichage', $id) : 'small';
                                $args = array(
                                    'post_type' => array('product', 'product_variation'),
                                    'post_status' => array('private', 'publish'),
                                    'numberposts' => -1,
                                    'orderby' => 'menu_order',
                                    'order' => 'asc',
                                    'post_parent' => $id
                                );
                                ?>

                                <?php echo nap_get_item($id, $args, $current_page, $options); ?>


                                <?php
                            endwhile;
                            wp_reset_query();
                            ?>
                        </div> 
                    </section>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>