<?php

/**
 * Template Name: Fiche technique
 *
 */
$nfiles = glob("fiches-techniques/[!\\.]*");

if ($nfiles !== FALSE) {

    $nb_fiche = count($nfiles) + 1;
} else {

    $nb_fiche = 1;
}

$fiche_num = str_pad($nb_fiche, 6, "0", STR_PAD_LEFT);
$product_id = $_GET['product_id'];
$variation_id = $_GET['variation_id'];
$file_title = "";
$parent_cat = wp_get_post_terms($product_id, 'product_cat', array( 'parent' => 0,'fields' => 'ids' ));
$sub_cat = wp_get_post_terms($product_id, 'product_cat', array( 'parent' =>$parent_cat[0],'fields' => 'names' ));

$file_title.=$sub_cat[0];

//fiche variable
if($variation_id !='undefined'){
    $code_variation = nap_load_variation_settings_fields($variation_id);
    $fiche_id = $code_variation['var_fiche'];
    $sku = nap_variable_meta($variation_id, 'sku');
    $gencod = $code_variation['var_gencod'];
    $itf14 = $code_variation['var_itf14'] ;
    $variable_product = wc_get_product($variation_id);
    $thumb_image = get_the_post_thumbnail($variation_id, 'medium');
    
    $file_title.="<br/>" . $variable_product->get_attribute('format') . " " . get_the_title($product_id);
    $color="<span class='variation_color'><strong><em>Couleur </em>: " . $variable_product->get_attribute('couleur') . "</strong></span>";
}

//fiche simple
else {
    
 $fiche_id = get_post_meta($product_id, '_fiche_simple', true); 
 $sku = get_post_meta($product_id, '_sku',true);
 $gencod = get_post_meta($product_id, '_gencod_simple', true); 
 $itf14 = get_post_meta($product_id,'_itf14_simple', true);
 $thumb_image = get_the_post_thumbnail($product_id, 'medium');
 
 $file_title.="<br/>" . get_the_title($product_id);
 
}



$icones = "";

if (get_field('fiche_icones', $fiche_id)):

    while (has_sub_field('fiche_icones', $fiche_id)) :
        $img = get_sub_field('fiche_icone', $fiche_id);
        $icones.= wp_get_attachment_image($img, 'shop_thumbnail');

    endwhile;
endif;
$file_content = "<html>
<head><title>" . $file_title . "</title>
  <style>
    .html,body {
        margin:0;
        padding:0;
        background: #f5f6fa;
    }
    .file_content, table, th,td {
        color: #233266;
        font-family: sans-serif;
        
        
        
    }
    .file_content .half_width {
        float: left ;
        width: 50%;
    }

    .file_header {
        overflow: hidden;
        padding: 0 30px;
    }

    .ft-table, .ft_infos, .ft_tolerance {
        margin:30px;
    }

    .ft-table-content {
        margin-top: 30px;
    }
    .ft-table-content p{
        background: #adb4ce;
        width: 100%;
        display: block;
        text-align: center;
        height: 30px;
        line-height: 30px;
        font-weight: bold;
        font-size: 14px;
        margin-bottom:0
    }


    .ft-table-content table {
        width: 100%;
        text-align: center;
        border: 1px solid #ccc;
        color: #233266;
    }
    .ft-table-content thead th {
        background-color:#d6dae6 
    }

    .ft-table-content th, .ft-table-content td{
        height: 30px;
    }


    .thumb_var img {
        padding-right: 100px;
        
        
    }

    .gallery-item {
        float: left;
        margin:5px;

    }
    .gallery-item img{
        width: 55px !important;
        height: 55px !important;
    }

    figcaption {
        display: none;
    }

    .bleu_zone {
        clear: both;
        background: #304682;
        color: #fff;
        overflow: hidden;
        margin: 50px 0;
    }

    .bleu_zone .half_width:first-child {
        position: relative;
        left: 100px
    }

    .ft-title {
        font-size: 20px;
        font-style: italic;
        height: 40px;
        border-bottom: 2px solid #ccc;
        font-weight: bold;
        color: #233266;
    }

    .ft_footer {
        border-top: 2px solid #ccc;
        padding-top: 30px;
        padding-left: 50px;
    }
</style>  
</head>    
<body><div class='file_content'>
    <div class='file_header'>
        <div class='half_width thumb_var' style='text-align:center'>
        " . $thumb_image. "
         </div>
        <div class='half_width' style='margin-left:20px;'>
            <h1>" . $file_title . "</h1>
            ".$color."
            " . nap_get_content($fiche_id) . "
                <div>" . $icones . "</div>
        </div>
        </div>
        <div class='bleu_zone'>
            <div class='half_width' style='position:relative; padding-left:30px'>
                <p>Code article : " . $sku . "</p>
                <p>Gencod : " . $gencod. "</p>
                <p>ITF 14 : " . $itf14 . "</p>

            </div>

            <div class='half_width' style='width:40%'>
                <p>Nomenclature douanière : " . get_field('ft_nomenclature_douaniere', $fiche_id) . "</p>
                <p>Pays origine : " . get_field('ft_pays_dorigine', $fiche_id) . "</p>
                <p>Labélisation : " . get_field('ft_labelisation', $fiche_id) . "</p>
            </div>
        </div>
        <div class='ft-table'>
            <div class='ft-title'>
                <span>Unité :</span>
            </div>
            <div class='ft-table-content'>
                <p>DIMENSIONS (1)</p>
                <table>
                    <thead>
                        <tr>
                            <th>L (cm)</th>
                            <th>l (cm)</th>
                            <th>H (cm)</th>
                            <th>Ø (cm)</th>
                            <th>Épaisseur (cm)</th>
                            <th>Capacité (cm)</th>
                            <th>Taille</th>
                            <th>Poids (g)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>" . get_field('ft_unite_L1', $fiche_id) . "</td>
                            <td>" . get_field('ft_unite_l2', $fiche_id) . "</td>
                            <td>" . get_field('ft_unite_H', $fiche_id) . "</td>
                            <td>" . get_field('ft_unite_diametre', $fiche_id) . "</td>
                            <td>" . get_field('ft_unite_epaisseur', $fiche_id) . "</td>
                            <td>" . get_field('ft_unite_capacite', $fiche_id) . "</td>
                            <td>" . get_field('ft_unite_taille', $fiche_id) . "</td>
                            <td>" . get_field('ft_unite_poids', $fiche_id) . "</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class='ft-table-footer'>
                <p><strong>Matière :</strong>" . get_field('ft_matiere_du_produit', $fiche_id) . "</p>
                <p><strong>Nombre de pli :</strong>" . get_field('ft_nb_de_plis', $fiche_id) . "</p>
                <p><strong>Grammage :</strong>" . get_field('ft_grammage', $fiche_id) . "</p>
            </div>
       
     </div>
     
    <div class='ft-table'>
            <div class='ft-title'>
                <span>UVC :</span>
            </div>
            <div class='ft-table-content'>
               <p>DIMENSIONS (1)</p>
                <table>
                    <thead>
                        <tr>
                            <th>L (cm)</th>
                            <th>l (cm)</th>
                            <th>H (cm)</th>
                            <th>Poids net (g)</th>
                            <th>Poids brut (g)</th> 
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>" . get_field('ft_uvc_L1', $fiche_id) . "</td>
                            <td>" . get_field('ft_uvc_l2', $fiche_id) . "</td>
                            <td>" . get_field('ft_uvc_H', $fiche_id) . "</td>
                            <td>" . get_field('ft_uvc_poids_net', $fiche_id) . "</td>
                            <td>" . get_field('ft_uvc_poids_brut', $fiche_id) . "</td>
                           
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class='ft-table-footer'>
                <p><strong>Nombre d'unité/UVC :</strong>" . get_field('ft_nombre_dunite_uvc', $fiche_id) . "</p>
               
            </div>
       
     </div>
     
     <div class='ft-table'>
            <div class='ft-title'>
                <span>Colis :</span>
            </div>
            <div class='ft-table-content'>
               <p>DIMENSIONS (1)</p>
                <table>
                    <thead>
                        <tr>
                            <th>L (cm)</th>
                            <th>l (cm)</th>
                            <th>H (cm)</th>
                            <th>Volume (cm3)</th>
                            <th>Poids net (Kg)</th>
                            <th>Poids brut (Kg)</th> 
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>" . get_field('ft_colis_L1', $fiche_id) . "</td>
                            <td>" . get_field('ft_colis_l2', $fiche_id) . "</td>
                            <td>" . get_field('ft_colis_H', $fiche_id) . "</td>
                            <td>" . get_field('ft_colis_volume', $fiche_id) . "</td>
                            <td>" . get_field('ft_colis_poids_net', $fiche_id) . "</td>
                            <td>" . get_field('ft_colis_poids_brut', $fiche_id) . "</td> 
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class='ft-table-footer'>
                <p><strong>Nombre d’UVC / colis :</strong>" . get_field('ft_nombre_duvc_colis', $fiche_id) . "</p>
               
            </div>
       
     </div>
     <div class='ft-table'>
            <div class='ft-title'>
                <span>Palette :</span>
            </div>
            <div class='ft-table-content'>
                <p>DIMENSIONS (1)</p>
                <table>
                    <thead>
                        <tr>
                            <th>L (cm)</th>
                            <th>l (cm)</th>
                            <th>H (cm)</th>
                            <th>Volume (cm3)</th>
                            <th>Poids brut (Kg)</th> 
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>" . get_field('ft_palette_L1', $fiche_id) . "</td>
                            <td>" . get_field('ft_palette_l2', $fiche_id) . "</td>
                            <td>" . get_field('ft_palette_H', $fiche_id) . "</td>
                            <td>" . get_field('ft_palette_volume', $fiche_id) . "</td>
                            <td>" . get_field('ft_palette_poids_brut', $fiche_id) . "</td>
                             
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class='ft-table-footer'>
                <p><strong>Nombre de colis à la couche :</strong>" . get_field('ft_nombre_de_colis_a_la_couche', $fiche_id) . "</p>
                <p><strong>Nombre de couches :</strong>" . get_field('ft_nombre_de_couche', $fiche_id) . "</p>    
                <p><strong>Nombre de colis / palette :</strong>" . get_field('ft_nombre_de_colis_palette', $fiche_id) . "</p>
                <p><strong>Type de palette :</strong>" . get_field('ft_type_de_palette', $fiche_id) . "</p>
            </div>
      
     </div>
     <div class='ft_infos'> 
         <div class='ft-title'>
                <span>Plus d’informations :</span>
         </div>
     " . get_field('ft_plus_dinformations', $fiche_id) . " 
         </div>
     <div class='ft_tolerance'> " . get_field('ft_tolerance', $fiche_id) . "</div>
     <div class='ft_footer'>
        <span class=ft_date>Mise à jour le " . date('d/m/Y', time()) . "</span>
     " . get_field('ft_footer', $fiche_id) . "
     </div>
   
</div>
<body></html>";
include("mpdf/mpdf.php");

$mpdf=new mPDF('utf-8', 'Letter', 0, '', 0, 0, 20, 20, 0, 0); 

$mpdf->WriteHTML($file_content);

$mpdf->Output('fiches-techniques/fiche-'.$fiche_num.'.pdf');
$pdf ='/fiches-techniques/fiche-'.$fiche_num.'.pdf';
header('Location:'.$pdf );
 