<?php
/**
 * Template Name: Contact
 *
 */
get_header();
$post_ID = 157;
?>

<div class="container clearfix" id="contact" data-page = "contact">
    <div class="container-bg abs-full"></div>
    <?php get_sidebar(); ?>
    <div class="contact-wrapper">
        <div class="right-container">
            <div class="left-panel fixed-full position--after-menu ">
                <div class="map">
                    <object id="map" type="image/svg+xml" data="<?php echo home_url('wp-content/themes/nap/assets/css/img/departements2.svg') ?>"></object>
                </div>
            </div>
        </div>
        <div class="right-panel full-height right">
            <div class="filter-wrapper search-filter fixed full-height form-wrapper border-l row">
                <h2>Trouver mon contact commercial</h2>
                <div class="filter">    
                    <form id="map-search" method="get" action='contact.php'>
                        <p class="form-element">    
                            <span class = "chevron bottom"></span>

                            <select id="selectCountry" >
                                <?php
                                if (get_field('contact_pays', $post_ID)):

                                    while (has_sub_field('contact_pays', $post_ID)) :
                                        ?>
                                        <option value="<?php the_sub_field('pays_code'); ?>" ><?php the_sub_field('pays_nom'); ?></option>

                                        <?php
                                    endwhile;
                                endif;
                                ?>
                            </select>

                        </p>
                        <p class="form-element cp"> 
                            <input placeholder="Code postal" class="search" id="search" type="text" name="search">
                            <input class ="search-btn" type="submit" />
                        </p>        

                    </form>
                </div>

                <?php
                if (get_field('zones_commerciaux', $post_ID)):
                    $i = 0;
                    while (has_sub_field('zones_commerciaux', $post_ID)) :
                        ?>
                        <div class="commercial commercial-details" data-zone = "zone<?php echo $i; ?>">
                            <figure style="background-image:url(<?php the_sub_field('photo_commercial'); ?>)"></figure>                 
                            <?php the_sub_field('infos_commercial'); ?>
                        </div>

                        <?php
                        // list zones par commercial 
                             if (get_sub_field('list_zones', $post_ID)):
                                $list_zone = array();
                                while (has_sub_field('list_zones', $post_ID)) :
                                    $list_zone[]= get_sub_field('num_zone');
                                endwhile;
                             endif;  
                        $i++;
                    endwhile;
                endif;
                ?>
                <span class="separation"></span>
                <div class="details">   
                    <div class="filter-bloc">
                        <div class="header">
                            <p><span>GMS</span></p>
                        </div>
                        <div class="bloc-content commercial-details">   
                            <figure style="background-image:url(<?php echo get_field('photo_gms', $post_ID) ?>)"></figure>                  
                            <?php echo get_field('contact_gms', $post_ID) ?>
                        </div>
                    </div>
                    <div class="filter-bloc">
                        <div class="header">
                            <p><span>Groupement</span></p>
                        </div>
                        <div class="bloc-content commercial-details">   
                            <figure style="background-image:url(<?php echo get_field('photo_groupement', $post_ID) ?>)"></figure>                   
                            <?php echo get_field('contact_groupement', $post_ID) ?>
                        </div>

                    </div>
                </div>  

            </div>
            <div class="contact-form right border-l row">
                <div class="form-wrapper inner-form">
                    <h2>Je souhaite être <br> contacté</h2>
                    <!--<form method="POST">    
                        <div class="clearfix">
                            <div class="row left half-col">
                                <input placeholder = "Nom" type="text" name="name" id="name" value="" />
                                <input placeholder = "Prénom" type="text" name="fname" id="fname" value="" />
                            </div>
                            <div class="row right half-col">
                                <input placeholder = "Mail" type="text" name="mail" id="mail" value="" />
                                <input placeholder = "Téléphone" type="text" name="phone" id="phone" value="" />
                            </div>
                            <textarea name="message" id="message" title="Message" placeholder="Message"></textarea>
                        </div>
                        <input type = "submit" class="btn pink-btn rounded" value = 'Envoyer'>



                    </form>-->
                    <?php echo do_shortcode( '[contact-form-7 id="558" title="Contact form"]' ); ?>
                </div>
                <div class="footer blue-bg abs font-small"> 
                    <h3 class="crete marker">Siège</h3>
                    <div class="content">
                        <div class="row left half-col">
                            <?php echo get_field('contact_adresse', $post_ID); ?>
                        </div>
                        <div class="row right half-col">
                            <?php echo get_field('contact_tel_fax', $post_ID); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>  
    </div>
</div>
<?php get_footer(); ?>