function loadProductContent() {
	sizeProductDetails = $('.product-details .list').length;
	if (sizeProductDetails < 2) {
		$('.product-info').outerWidth('78.3%'); 
	}
	$('.pa_couleur li').getListColors();
	$('.pa_couleur li').selectColor();
	$('.pa_format li').selectFormat();
	$('#zoom').zoom();
	$('article[data-color], .pa_couleur li').click(function(e) {
		$(this).selectSlide($('#slides')); 
	});
	$('#mozaique').open_gallery();
	initFunction();
	$.fn.responsive();
	setTimeout(function(){
		$.fn.productAnimation();
		$('#product .product-list').showRightPanel();
		$.fn.slider_product();
		$('.pa_couleur li').selectColor();
		$('.pa_format li').selectFormat();
		$('.color-list.selected').selectSlide($('#slides'));
	},100)
	$('.download-btn:not(.download_file)').click(function(e){
		e.stopPropagation();
	});
}
$(function(){
	var initFunction=function(){
		$('a[href^="#"], .easyzoom img').click(function(e){
			e.preventDefault();
		});
	};//END init Function
	$.fn.zoom = function(){ //Zoom on Image
		$(this).on('click', function() {
			var zoom = $(this);
			$( ".easyzoom" ).each(function( i ) {
				var $easyzoom = $(this).easyZoom();
				var api = $easyzoom.filter('.easyzoom--with-toggle').data('easyZoom');
				api.teardown();
				var $this = $(this);
				if ($this.data("active") === true) {
					$this.data("active", false);
					zoom.removeClass("active");
					api.teardown();
				} else {
					$this.data("active", true);
					zoom.addClass("active");
					api._init();
				}
			});
		});
	} //END Zoom On Image
	$.fn.getListColors = function(){
		$(this).each(function(){
			var colorWrapper = $(this).find('>span'),
			color = colorWrapper.data('color');
			colorWrapper.css('background' , color);
		})
	}
	$.fn.getListFormat = function(){
		$(this).each(function(){
			var formatWrapper = $(this).find('>span'),
			formatW = formatWrapper.data('width'),
			formatH = formatWrapper.data('height');
			formatWrapper.css({'height' : formatH , 'width' : formatW });
		})
	}
	$.fn.selectColor= function(){
		$(this).on('click',function(){
			$(this).parent().parent().find('li').removeClass('selected');
			if (!($(this).hasClass('disabled'))){
				$(this).toggleClass('selected');
			}
		})	
	}
	$.fn.selectFormat = function(){
		$(this).on('click',function(){
			var actifImage = $(this).find('img').data('img-active'),
			initialImage = $(this).find('img').data('img');
			$(this).parent().parent().find('li').each(function(){
				img = $(this).find('img');


				img.attr('src',img.data('img'));
			})
			$(this).parent().parent().find('li').removeClass('selected');
			if (!($(this).hasClass('disabled'))){
				$(this).toggleClass('selected');
			}
			if ($(this).hasClass('selected')){
				$(this).find('img').attr('src',actifImage);
			}else{
				$(this).find('img').attr('src',initialImage);
			}
		})	
	}
	$.fn.slider_product = function(){
		$('#slides').not('.slick-initialized').slick({
			autoplay: false,
			arrows:true,
			dots: true, 
			slidesToShow: 1,
			adaptiveHeight: true,
		//centerMode: true,
		centerPadding: '0px',
	});
	}
	$.fn.selectSlide = function(slide){
		var data = $(this).data("color"),
		dataIndex = slide.find("[data-color="+data+"]").data("slick-index"),
		slideno = $(this).data('color');
		slide.slick('slickGoTo', dataIndex);
	}
	$.fn.open_gallery = function(){
		$(this).on('click',function(){
			tl = new TimelineMax()
			tl.staggerFromTo('.slides-wrapper .gallery article',0.3,{opacity:0,y:100},{opacity:1,y:0},0.1,0);
			tl.fromTo('.gallery',0.5,{opacity:0,visibility:"hidden"},{opacity:1,visibility:"visible"},0);
			tl.fromTo('.nav-slider',0.1,{opacity:1},{opacity:0},0);
			tl.fromTo('#slides',0.5,{opacity:1},{opacity:0},0);
		});
		$('.gallery').on('click','.close-btn,article',function(){
			$('.gallery').fadeTo( "slow", 0).css('visibility','hidden');
			$('#slides,.nav-slider').fadeTo( "slow", 1);

		})
	}
	$.fn.showRightPanelAnimation = function(removeClass,addClass){
		$(this).each(function(i) {
			var $li = $(this);
			setTimeout(function() {
				$li.removeClass(removeClass).addClass(addClass);
			}, i*100); // delay 100 ms
		});
	}
	$.fn.showRightPanel = function(){
		var wrapper = $(this),
		widthPanel = wrapper.outerWidth();
		wrapper.css('right', -widthPanel)
		$('.show-product').on('click',function(){
			$('.product-details').css('right', widthPanel);
			wrapper.css({'right': 0, 'opacity':1});
			$('#product .product-list article').showRightPanelAnimation('fadeOutUp','hidden-elem visible-elem animated fadeInDown');
		})
		$(this).on('click','.close-btn',function(){
			wrapper.css('right', -widthPanel);
			$('#product .product-list article').showRightPanelAnimation('fadeInDown','fadeOutUp');
			$('.product-details').css('right', 0);
		})
	}
	$.fn.productAnimation = function(){

           //first format Actif
           var activeImg = $('.format-label #format_0').data('img-active');
           $('.format-label #format_0').attr('src',activeImg);

           tlProduct = new TimelineMax();
           tlProduct.fromTo('.product-images',0.4,{autoAlpha:0, marginLeft:"-10%"},{autoAlpha:1, marginLeft:"0"},0);
           tlProduct.staggerFromTo('.product-details .list',0.4,{opacity:0, marginLeft:"-10%"},{opacity:1, marginLeft:"0"},0.4,0.2);
           tlProduct.fromTo('.product-info',0.4,{autoAlpha:0, marginLeft:"-10%"},{autoAlpha:1, marginLeft:"0"},0.5);
       }
       $('.product-list article img, .product-list article ul li').on('click', function() {

	       	$('head').append($('.header-shop'));
	       	var toLink = $(this).data('link');
	       	history.pushState(null, null, toLink);
	       	$('.load-page').parent().addClass('active');
	       	$('.load-page').load(toLink,function(){
				loadProductContent();
				$('html').css('overflow','hidden');
			});
       })
       loadProductContent();
   });