/*var zones = {zone1: ['02' , '08' , '14' , '22' , '27' , '29' , '35' , '50' , '51' , '53' , '55' , '56' , '59' , '61' , '62' , '76' , '80' , 'BE' , 'LU'],
zone2: [ '60' , '75',  '77' , '78' , '91',  '92' , '93' , '94' , '95'],	    
zone3: ['03' , '18' , '28' , '36' , '37' , '41' , '44' , '45' , '49' , '58' , '72' , '89'],
zone4: ['12' , '15' , '16' , '17' , '19' , '23' , '24' , '31' , '32' , '33' , '40' , '46' , '47' , '64' , '65' , '79' , '82' , '85' , '86' , '87'],
zone5: ['01' , '04' , '05' , '07' , '10' , '21' , '25' , '26' , '38' , '39' , '42' , '43' , '52' , '54' , '57' , '63' , '67' , '68' , '69' , '70' , '71' , '73' , '74' , '88' , '90' , 'CH'],
zone6: ['06' , '09' , '11' , '13' , '20' , '30' , '34' , '48' , '66' , '81' , '83' , '84' , '2A' , '2B' , 'ES']}
*/
var zones = jQuery.parseJSON(zonesL.listZones);
function initMap(){
	setTimeout(function(){
		if(jQuery(document).find('#map').length){
			svg = jQuery("#map").getSVG();
			jQuery.map(zones,  function(zoneDeps,zone){
				$.map(zoneDeps, function(dep,i){
					var initialClassDep = 'st3';
					var initialClassNum = 'st5';
					var proceed = false;
					if (svg.find("#nap-carte-dep-"+dep).length) {
						svg.find("#nap-carte-dep-"+dep).attr('class', initialClassDep + ' ' + zone + ' zonedep');
						svg.find("#nap-carte-numero-dep-"+dep).attr('class', initialClassNum + ' ' + zone + 'num zonenum');
						proceed = true;
					}
					if (svg.find("#nap-carte-pays-"+dep).length) {
						svg.find("#nap-carte-pays-"+dep).attr('class', initialClassDep + ' ' + zone + ' zonedep');
						svg.find("#nap-carte-numero-pays-"+dep).attr('class', initialClassNum + ' ' + zone + 'num zonenum');
						proceed = true;
					}
					// setup events
					if (proceed) {
						svg.find("." + zone).on('mouseenter', function(){
							svg.find("." + zone).attr('class', initialClassDep + ' red ' + zone + ' zonedep');
							svg.find("." + zone + 'num').attr('class', initialClassNum + ' blue ' + zone + 'num zonenum');
						}).on('mouseout', function(){
							if (zone !== window.selectedZone) {
								svg.find("." + zone).attr('class', initialClassDep + ' ' + zone + ' zonedep');
								svg.find("." + zone + 'num').attr('class', initialClassNum + ' ' + zone + 'num zonenum');
							}
						}).on('click', function(){
							selectZone(zone, initialClassDep, initialClassNum);
						});
					}
				});
			})
		}
	},0);
}
function selectZone(zone, initialClassDep, initialClassNum) {
	//show commercial details
	jQuery( ".commercial-details" ).each(function( i ) {
		var linkedZone = jQuery(this).data('zone');
		//console.log(jQuery(this));
		//console.log(linkedZone, zone, zone === linkedZone);
		if(zone === linkedZone){
			jQuery(this).slideDown("slow");
		}
		else{
			jQuery(this).slideUp("slow");
		}
	});
	svg.find("." + zone).attr('class', initialClassDep + ' red ' + zone + ' zonedep');
	svg.find("." + zone + 'num').attr('class', initialClassNum + ' blue ' + zone + 'num zonenum');
	if (window.selectedZone && window.selectedZone !== zone) {
		svg.find("." + window.selectedZone).attr('class', initialClassDep + ' ' + window.selectedZone + ' zonedep');
		svg.find("." + window.selectedZone + 'num').attr('class', initialClassNum + ' ' + window.selectedZone + 'num zonenum');
	}
	window.selectedZone = zone;
}

jQuery("#map-search").bind('submit',function(e) {
	e.preventDefault();
	var search = jQuery('#search').val(),
	number = search.substring(0, 2),
	initialClassDep = 'st3',
	initialClassNum = 'st5';
	svg = jQuery("#map").getSVG();
	jQuery.map(zones,  function(zoneDeps,zone){
		jQuery.map(zoneDeps, function(dep,i){
			if(dep == number){
				selectZone(zone, initialClassDep, initialClassNum);
				return ;
			}
		});
	});
});
//Highlight zone when select country
jQuery("#selectCountry").on('change',function(e) {
	var country = e.target.value,
	initialClassDep = 'st3',
	initialClassNum = 'st5';
	if (country === 'FR') {
		jQuery('.form-element.cp').slideDown('slow');
		selectZone(null, initialClassDep, initialClassNum);
		return;
	}else{
		jQuery('.form-element.cp').slideUp('slow');
	}
	svg = jQuery("#map").getSVG();
	jQuery.map(zones,  function(zoneDeps,zone){
		jQuery.map(zoneDeps, function(dep,i){
			if(dep === country){
				selectZone(zone, initialClassDep, initialClassNum);
				return ;
			}
		});
	});
});

jQuery(document).ready(function(){
	initMap();
}); //end document ready